@extends('layouts.app')

@section('title', 'Payment Cancelled')

@section('content')
<div class="store-container">
    <div class="container">
        <div class="store-result">
            <div class="icon cancel">
                <svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" fill="currentColor" class="bi bi-x-circle-fill" viewBox="0 0 16 16">
                    <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.354 4.646a.5.5 0 1 0-.708.708L7.293 8l-2.647 2.646a.5.5 0 0 0 .708.708L8 8.707l2.646 2.647a.5.5 0 0 0 .708-.708L8.707 8l2.647-2.646a.5.5 0 0 0-.708-.708L8 7.293 5.354 4.646z"/>
                </svg>
            </div>
            <h2>Payment Cancelled</h2>
            <p>Your purchase of {{ $transaction->package->name }} has been cancelled. No charges have been made to your account.</p>
            
            <div class="options">
                <p>Would you like to:</p>
                <div class="buttons">
                    <a href="{{ route('store.payment.checkout', $transaction->package->slug) }}" class="btn">Try Again</a>
                    <a href="{{ route('store.index') }}" class="btn btn-secondary">Return to Store</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection